IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Clientes_Links_Token') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Clientes_Links_Token
END
GO

CREATE FUNCTION dbo.CF_Clientes_Links_Token(
											@pFormato			VARCHAR(1),		/*A: Alfanumerico. N: Numerico*/
											@pCant_Carac_Dig	SMALLINT		/*Cantidad de Caracteres/Digitos al retornar en el Token*/
											)
RETURNS VARCHAR(50)
AS
BEGIN

DECLARE @Token				VARCHAR(50)
DECLARE	@Letras				CHAR(62)
DECLARE	@Numeros			CHAR(10)
DECLARE @Posicion			SMALLINT
DECLARE @Valor_Random		FLOAT
DECLARE @Valor_Random_INT	INT
DECLARE @Cada_Caracter		CHAR(1)
DECLARE @Flag_Existe_Token	TINYINT

-------------------------------------------------------------------------------------------------------------------------------------
/*
VERSIONES:
02/08/2022 Creacin de funcin.
*/
-------------------------------------------------------------------------------------------------------------------------------------

IF(@pFormato NOT IN ('A', 'N'))
BEGIN
	SET @pFormato = 'A'
END

IF(@pCant_Carac_Dig < 1)
BEGIN
	SET @pCant_Carac_Dig = 1
END

-------------------------------------------------------------------------------------------------------------------------------------

SET @Token		= ''
SET @Letras		= '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'
SET @Numeros	= '0123456789'

-------------------------------------------------------------------------------------------------------------------------------------

IF(@pFormato = 'A')
BEGIN
	SET @Posicion = 1

	WHILE (@Posicion < @pCant_Carac_Dig + 1)
	BEGIN
		SELECT @Valor_Random = rndResult FROM rndView
	
		SET @Cada_Caracter = SUBSTRING(@Letras, CAST(ROUND(@Valor_Random * 62,0) AS INT), 1)

		SET @Token = LTRIM(RTRIM(@Token)) + @Cada_Caracter
	
		SET @Posicion = @Posicion + 1
	END
END

-------------------------------------------------------------------------------------------------------------------------------------

IF(@pFormato = 'N')
BEGIN
	SET @Posicion = 1

	WHILE (@Posicion < @pCant_Carac_Dig + 1)
	BEGIN
		SELECT @Valor_Random = rndResult FROM rndView

		SET @Valor_Random_INT = CAST(ROUND(@Valor_Random * 10,0) AS INT)
		
		IF(@Valor_Random_INT = 0)
		BEGIN
			SET @Valor_Random_INT = 1
		END
	
		SET @Cada_Caracter = SUBSTRING(@Numeros, @Valor_Random_INT, 1)

		SET @Token = LTRIM(RTRIM(@Token)) + @Cada_Caracter
	
		SET @Posicion = @Posicion + 1
	END

	IF(@pCant_Carac_Dig = 10)	--Por Lectores intelektron que lo maximo que leen es: 4.294.967.295 (2^32)
	BEGIN
		SET @Token = STUFF(@Token, 1, 1, '3')
	END
END

-------------------------------------------------------------------------------------------------------------------------------------

SET @Flag_Existe_Token = ISNULL((SELECT 
								TOP 1 1
								FROM Clientes_Links
								WHERE
								Token = @Token)
								, 0)

IF(@Flag_Existe_Token = 1)
BEGIN
	SET @Token = (dbo.CF_Clientes_Links_Token(@pFormato, @pCant_Carac_Dig))
END
-------------------------------------------------------------------------------------------------------------------------------------

RETURN @Token
END

--SELECT dbo.CF_Clientes_Links_Token('A', 32)
--SELECT dbo.CF_Clientes_Links_Token('N', 10)